import { Observable } from "@nativescript/core";
export { CMBReaderConstants } from './cmbsdk-nativescript.common';
export declare class CMBReader extends Observable {
    private ccpBridge;
    private readerDeviceBridgeListener;
    private permissionBridgeListener;
    constructor();
    loadScanner(deviceType: number): Promise<any>;
    connect(): Promise<any>;
    disconnect(): Promise<any>;
    startScanning(): Promise<any>;
    stopScanning(): Promise<any>;
    setSymbologyEnabled(symbology: number, enable: boolean): Promise<any>;
    isSymbologyEnabled(symbology: number): Promise<any>;
    setCameraMode(cameraMode: number): void;
    setPreviewOptions(previewOptions: number): void;
    setPreviewOverlayMode(previewOverlayMode: number): void;
    setPreviewContainerPositionAndSize(x: number, y: number, w: number, h: number): void;
    setPreviewContainerFullScreen(): void;
    setStopScannerOnRotate(stop: boolean): void;
    setLightsOn(on: boolean): Promise<any>;
    isLightsOn(): Promise<any>;
    enableImage(enable: boolean): Promise<any>;
    enableImageGraphics(enable: boolean): Promise<any>;
    sendCommand(commandString: string): Promise<any>;
    resetConfig(): Promise<any>;
    registerSDK(key: string): void;
    enableCameraFlag(codeMask: number, flag: number): Promise<any>;
    disableCameraFlag(codeMask: number, flag: number): Promise<any>;
    setCameraParam(codeMask: number, param: number, value: number): Promise<any>;
    getAvailability(): Promise<any>;
    getConnectionState(): Promise<any>;
    beep(): Promise<any>;
    getDeviceBatteryLevel(): Promise<any>;
    getSdkVersion(): string;
    setParser(parserType: number): Promise<any>;
    setReadStringEncoding(readStringEncoding: number): Promise<any>;
    setMDMReportingEnabled(enabled: boolean): void;
    createMDMAuthCredentials(username: string, password: string, clientID: string, clientSecret: string): void;
    setPreviewContainerBelowStatusBar(arg: boolean): void;
    getCameraExposureCompensationRange(): Promise<any>;
    setCameraExposureCompensation(exposureCompensation: number): Promise<any>;
    loadCameraConfig(): Promise<any>;
    showToast(message: string): void;
    hideToast(): void;
    scanImageFromUri(uri: string): Promise<any>;
    scanImageFromBase64(base64: string): Promise<any>;
    setPairedBluetoothDevice(btDevice: string): void;
    getPairedBluetoothDevice(): Promise<any>;
    private createResponseListener;
    private getActivity;
}
