import { CMBReaderConstants } from './cmbsdk-nativescript.common';
import { Observable, Application } from "@nativescript/core";
const androidSupport = global.androidx && global.androidx.appcompat ? global.androidx.core.app : android.support.v4.app;
export { CMBReaderConstants } from './cmbsdk-nativescript.common';
export class CMBReader extends Observable {
    constructor() {
        super();
        this.readerDeviceBridgeListener = new com.cognex.cmbcrossplatform.interfaces.ReaderDeviceBridgeListener({
            connectionStateChanged: (connectionState) => {
                this.notify({ eventName: CMBReaderConstants.EVENTS.ConnectionStateChanged, object: this, data: connectionState });
            },
            readResultReceived: (resultAsJson) => {
                let resultAsObject = JSON.parse(resultAsJson);
                this.notify({
                    eventName: CMBReaderConstants.EVENTS.ReadResultReceived, object: this, data: {
                        results: resultAsObject.results,
                        subResults: resultAsObject.subResults,
                        xml: resultAsObject.xml
                    }
                });
            },
            availabilityChanged: (availability) => {
                this.notify({ eventName: CMBReaderConstants.EVENTS.AvailabilityChanged, object: this, data: availability });
            },
            scanningStateChanged: (state) => {
                this.notify({ eventName: CMBReaderConstants.EVENTS.ScanningStateChanged, object: this, data: state });
            }
        });
        this.permissionBridgeListener = new com.cognex.cmbcrossplatform.interfaces.PermissionBridgeListener({
            requestPermission: (permissions, requestCode) => {
                androidSupport.ActivityCompat.requestPermissions(this.getActivity(), permissions, requestCode);
            }
        });
        this.ccpBridge = new com.cognex.cmbcrossplatform.CCPBridge(this.getActivity(), this.readerDeviceBridgeListener, this.permissionBridgeListener);
        Application.android.on("activityRequestPermissions", (args) => {
            if (args.requestCode == com.cognex.cmbcrossplatform.CCPBridge.CAMERA_REQUEST_PERMISSION_CODE) {
                if (args.grantResults.length > 0 && args.grantResults[0] === android.content.pm.PackageManager.PERMISSION_GRANTED) {
                    this.ccpBridge.connect(null);
                }
            }
        });
    }
    loadScanner(deviceType) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.loadScanner(this.createResponseListener(resolve, reject), deviceType);
        });
    }
    connect() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.connect(this.createResponseListener(resolve, reject));
        });
    }
    disconnect() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.disconnect(this.createResponseListener(resolve, reject));
        });
    }
    startScanning() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.startScanning(this.createResponseListener(resolve, reject));
        });
    }
    stopScanning() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.stopScanning(this.createResponseListener(resolve, reject));
        });
    }
    setSymbologyEnabled(symbology, enable) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.setSymbologyEnabled(this.createResponseListener(resolve, reject), symbology, enable);
        });
    }
    isSymbologyEnabled(symbology) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.isSymbologyEnabled(this.createResponseListener(resolve, reject), symbology);
        });
    }
    setCameraMode(cameraMode) {
        this.ccpBridge.setCameraMode(cameraMode);
    }
    setPreviewOptions(previewOptions) {
        this.ccpBridge.setPreviewOptions(previewOptions);
    }
    setPreviewOverlayMode(previewOverlayMode) {
        this.ccpBridge.setPreviewOverlayMode(previewOverlayMode);
    }
    setPreviewContainerPositionAndSize(x, y, w, h) {
        this.ccpBridge.setPreviewContainerPositionAndSize(x, y, w, h);
    }
    setPreviewContainerFullScreen() {
        this.ccpBridge.setPreviewContainerFullScreen();
    }
    setStopScannerOnRotate(stop) {
        this.ccpBridge.setStopScannerOnRotate(stop);
    }
    setLightsOn(on) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.setLightsOn(this.createResponseListener(resolve, reject), on);
        });
    }
    isLightsOn() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.isLightsOn(this.createResponseListener(resolve, reject));
        });
    }
    enableImage(enable) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.enableImage(this.createResponseListener(resolve, reject), enable);
        });
    }
    enableImageGraphics(enable) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.enableImageGraphics(this.createResponseListener(resolve, reject), enable);
        });
    }
    sendCommand(commandString) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.sendCommand(this.createResponseListener(resolve, reject), commandString);
        });
    }
    resetConfig() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.resetConfig(this.createResponseListener(resolve, reject));
        });
    }
    registerSDK(key) {
        this.ccpBridge.registerSDK(key);
    }
    enableCameraFlag(codeMask, flag) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.editCameraFlag(this.createResponseListener(resolve, reject), codeMask, flag, true);
        });
    }
    disableCameraFlag(codeMask, flag) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.editCameraFlag(this.createResponseListener(resolve, reject), codeMask, flag, false);
        });
    }
    setCameraParam(codeMask, param, value) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.setCameraParam(this.createResponseListener(resolve, reject), param, value, codeMask);
        });
    }
    getAvailability() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.getAvailability(this.createResponseListener(resolve, reject));
        });
    }
    getConnectionState() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.getConnectionState(this.createResponseListener(resolve, reject));
        });
    }
    beep() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.beep(this.createResponseListener(resolve, reject));
        });
    }
    getDeviceBatteryLevel() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.getDeviceBatteryLevel(this.createResponseListener(resolve, reject));
        });
    }
    getSdkVersion() {
        return com.cognex.cmbsdk.DataManSystem.getVersion();
    }
    setParser(parserType) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.setParser(this.createResponseListener(resolve, reject), parserType);
        });
    }
    setReadStringEncoding(readStringEncoding) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.setReadStringEncoding(this.createResponseListener(resolve, reject), readStringEncoding);
        });
    }
    setMDMReportingEnabled(enabled) {
        console.log("setMDMReportingEnabled is not available on Android yet");
    }
    createMDMAuthCredentials(username, password, clientID, clientSecret) {
        console.log("createMDMAuthCredentials is not available on Android yet");
    }
    setPreviewContainerBelowStatusBar(arg) {
        console.log("setPreviewContainerBelowStatusBar is available only on iOS");
    }
    getCameraExposureCompensationRange() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.getCameraExposureCompensationRange(this.createResponseListener(resolve, reject));
        });
    }
    setCameraExposureCompensation(exposureCompensation) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.setCameraExposureCompensation(this.createResponseListener(resolve, reject), exposureCompensation);
        });
    }
    loadCameraConfig() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.loadCameraConfig(this.createResponseListener(resolve, reject));
        });
    }
    showToast(message) {
        this.ccpBridge.showToast(message);
    }
    hideToast() {
        this.ccpBridge.hideToast(true);
    }
    scanImageFromUri(uri) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.scanImage(this.createResponseListener(resolve, reject), com.cognex.cmbcrossplatform.enums.ImageSourceType.URI, uri);
        });
    }
    scanImageFromBase64(base64) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.scanImage(this.createResponseListener(resolve, reject), com.cognex.cmbcrossplatform.enums.ImageSourceType.BASE64, base64);
        });
    }
    setPairedBluetoothDevice(btDevice) {
        this.ccpBridge.setPairedBTDeviceMacAddress(btDevice);
    }
    getPairedBluetoothDevice() {
        return new Promise((resolve, reject) => {
            reject("getPairedBluetoothDevice is available only on iOS");
        });
    }
    createResponseListener(resolve, reject) {
        return new com.cognex.cmbcrossplatform.interfaces.APIResponseListener({
            successWithObject(result) {
                resolve(result);
            },
            error(errorCode, errorMessage) {
                reject(errorMessage);
            }
        });
    }
    getActivity() {
        return Application.android.foregroundActivity || Application.android.startActivity;
    }
}
//# sourceMappingURL=cmbsdk-nativescript.android.js.map