import { Observable } from '@nativescript/core';
export declare class CMBReaderConstants {
    static DEVICE_TYPE: {
        MXReader: number;
        Camera: number;
        Bluetooth: number;
    };
    static SYMBOLOGY: {
        Unknown: number;
        DataMatrix: number;
        QR: number;
        C128: number;
        UpcEan: number;
        C11: number;
        C39: number;
        C93: number;
        I2o5: number;
        CodaBar: number;
        EanUcc: number;
        PharmaCode: number;
        Maxicode: number;
        Pdf417: number;
        Micropdf417: number;
        Databar: number;
        Planet: number;
        Postnet: number;
        FourStateJap: number;
        FourStateAus: number;
        FourStateUpu: number;
        FourStateImb: number;
        Vericode: number;
        Rpc: number;
        Msi: number;
        Azteccode: number;
        Dotcode: number;
        C25: number;
        C39ConvertToC32: number;
        Ocr: number;
        FourStateRm: number;
        Telepen: number;
    };
    static SYMBOLOGY_NAME: {
        Unknown: string;
        DataMatrix: string;
        QR: string;
        C128: string;
        UpcEan: string;
        C11: string;
        C39: string;
        C93: string;
        I2o5: string;
        CodaBar: string;
        EanUcc: string;
        PharmaCode: string;
        Maxicode: string;
        Pdf417: string;
        Micropdf417: string;
        Databar: string;
        Planet: string;
        Postnet: string;
        FourStateJap: string;
        FourStateAus: string;
        FourStateUpu: string;
        FourStateImb: string;
        Vericode: string;
        Rpc: string;
        Msi: string;
        Azteccode: string;
        Dotcode: string;
        C25: string;
        C39ConvertToC32: string;
        Ocr: string;
        FourStateRm: string;
        Telepen: string;
    };
    static AVAILABILITY: {
        Unknown: number;
        Available: number;
        Unavailable: number;
    };
    static CONNECTION_STATE: {
        Disconnected: number;
        Connecting: number;
        Connected: number;
        Disconnecting: number;
        Unavailable: number;
    };
    static CAMERA_MODE: {
        NoAimer: number;
        PassiveAimer: number;
        FrontCamera: number;
    };
    static OVERLAY_MODE: {
        OM_CMB: number;
        OM_LEGACY: number;
    };
    static CAMERA_PREVIEW_OPTION: {
        Defaults: number;
        NoZoomBtn: number;
        NoIllumBtn: number;
        HwTrigger: number;
        Paused: number;
        AlwaysShow: number;
        HighResolution: number;
        HighFramerate: number;
        ShowCloseButton: number;
        KeepPreviewInPausedState: number;
        QHDResolution: number;
    };
    static PARSERS: {
        NONE: number;
        AUTO: number;
        AAMVA: number;
        GS1: number;
        HIBC: number;
        ISBT128: number;
        IUID: number;
        SCM: number;
    };
    static READSTRING_ENCODING: {
        AUTO: number;
        UTF_8: number;
        UTF_16: number;
        UTF_32: number;
        ISO_8859_1: number;
        ISO_8859_2: number;
        Shift_JIS: number;
        US_ASCII: number;
        US_ASCII_SHOW_NON_PRINTABLE: number;
    };
    static EVENTS: {
        ReadResultReceived: string;
        AvailabilityChanged: string;
        ConnectionStateChanged: string;
        ScanningStateChanged: string;
    };
}
export declare class CMBReader extends Observable {
    loadScanner(deviceType: number): Promise<any>;
    connect(): Promise<any>;
    disconnect(): Promise<any>;
    startScanning(): Promise<any>;
    stopScanning(): Promise<any>;
    setSymbologyEnabled(symbology: number, enable: boolean): Promise<any>;
    isSymbologyEnabled(symbology: number): Promise<any>;
    setCameraMode(cameraMode: number): void;
    setPreviewOptions(previewOptions: number): void;
    setPreviewOverlayMode(previewOverlayMode: number): void;
    setPreviewContainerPositionAndSize(x: number, y: number, w: number, h: number): void;
    setPreviewContainerBelowStatusBar(arg: boolean): void;
    setLightsOn(on: boolean): Promise<any>;
    isLightsOn(): Promise<any>;
    enableImage(arg: boolean): Promise<any>;
    enableImageGraphics(arg: boolean): Promise<any>;
    sendCommand(commandString: string): Promise<any>;
    resetConfig(): Promise<any>;
    registerSDK(key: string): void;
    getAvailability(): Promise<any>;
    getConnectionState(): Promise<any>;
    beep(): Promise<any>;
    getDeviceBatteryLevel(): Promise<any>;
    getSdkVersion(): string;
    setPreviewContainerFullScreen(): void;
    setStopScannerOnRotate(arg: boolean): void;
    enableCameraFlag(codeMask: number, flag: number): Promise<any>;
    disableCameraFlag(codeMask: number, flag: number): Promise<any>;
    setCameraParam(codeMask: number, param: number, value: number): Promise<any>;
    setParser(parserType: number): Promise<any>;
    setReadStringEncoding(readStringEncoding: number): Promise<any>;
    createMDMAuthCredentials(username: string, password: string, clientID: string, clientSecret: string): void;
    setMDMReportingEnabled(enabled: boolean): void;
    getCameraExposureCompensationRange(): Promise<any>;
    setCameraExposureCompensation(exposureCompensation: number): Promise<any>;
    loadCameraConfig(): Promise<any>;
    showToast(message: string): void;
    hideToast(): void;
    scanImageFromUri(uri: string): Promise<any>;
    scanImageFromBase64(base64: string): Promise<any>;
    setPairedBluetoothDevice(btDevice: string): void;
    getPairedBluetoothDevice(): Promise<any>;
}
