//
//  CDMStreamConnectorPrivate.h
//  DataManSDK
//
//  Created by Ferenc Knebl on 02/12/14.
//  Copyright (c) 2014 Cognex Corporation. All rights reserved.
//

#ifndef DataManSDK_CDMStreamConnectorPrivate_h
#define DataManSDK_CDMStreamConnectorPrivate_h

#import "CDMStreamConnector.h"

@interface CDMStreamConnector()

@property (strong) NSInputStream* connectorInputStream;
@property (strong) NSOutputStream* connectorOutputStream;

@property (weak) id<CDMConnectorDelegate> connectorDelegate;

- (id)initWithEncoding:(NSStringEncoding)encoding inputBufferSize:(int)bufferSize delegate:(id<CDMConnectorDelegate>)delegate delegateQueue:(dispatch_queue_t)queue;

- (void)authenticateWithUsername:(NSString*)username password:(NSString*)password;

- (BOOL)rawconnectWithTimeout:(NSTimeInterval)timeout;

- (void)initConnectionWithAuthentication:(BOOL)authenticate;

- (void)closeStreams;

- (void)scheduleConnectionTimerWithInterval:(NSTimeInterval)interval;

@end

#endif
