
declare class CCPBridge extends NSObject {

	static alloc(): CCPBridge; // inherited from NSObject

	static new(): CCPBridge; // inherited from NSObject

	ccpPluginDelegate: CMBReaderDeviceDelegate;

	ccpPluginScanningStateDelegate: CMBObserversDelegate;

	beep(resultCallback: (p1: string, p2: string) => void): void;

	connect(resultCallback: (p1: string, p2: string) => void): void;

	createMDMAuthCredentialsWithUsernamePasswordClientIDClientSecret(username: string, password: string, clientID: string, clientSecret: string): void;

	disableCameraFlagForMaskCompletion(flag: number, mask: number, resultCallback: (p1: string, p2: string) => void): void;

	disconnect(resultCallback: (p1: string, p2: string) => void): void;

	enableCameraFlagForMaskCompletion(flag: number, mask: number, resultCallback: (p1: string, p2: string) => void): void;

	enableImageCompletion(enabled: boolean, resultCallback: (p1: string, p2: string) => void): void;

	enableImageGraphicsCompletion(enabled: boolean, resultCallback: (p1: string, p2: string) => void): void;

	getAvailability(resultCallback: (p1: string, p2: string) => void): void;

	getCameraExposureCompensationRange(resultCallback: (p1: string, p2: string) => void): void;

	getConnectionState(resultCallback: (p1: string, p2: string) => void): void;

	getDeviceBatteryLevel(resultCallback: (p1: string, p2: string) => void): void;

	getPairedBluetoothDevice(resultCallback: (p1: string, p2: string) => void): void;

	getSdkVersion(resultCallback: (p1: string, p2: string) => void): void;

	hideMessage(): void;

	initReaderWithClassCallback(deviceClass: DataManDeviceClass, resultCallback: () => void): void;

	isLightsOnWithCompletion(resultCallback: (p1: string, p2: string) => void): void;

	isSymbologyEnabledCompletion(symbology: CMBSymbology, resultCallback: (p1: string, p2: string) => void): void;

	loadCameraConfig(resultCallback: (p1: string, p2: string) => void): void;

	registerSDK(key: string): void;

	resetConfigWithCompletion(resultCallback: (p1: string, p2: string) => void): void;

	scanImageFromBase64Completion(base64: string, resultCallback: (p1: string, p2: string) => void): void;

	scanImageFromUriCompletion(uri: string, resultCallback: (p1: string, p2: string) => void): void;

	sendCommandCompletion(dmcc: string, resultCallback: (p1: string, p2: string) => void): void;

	setCameraExposureCompensationCompletion(arg: number, resultCallback: (p1: string, p2: string) => void): void;

	setCameraMode(cameraMode: CDMCameraMode): void;

	setCameraParamParamValueForMaskCompletion(param: number, value: number, mask: number, resultCallback: (p1: string, p2: string) => void): void;

	setLightsOnCompletion(lightsOn: boolean, resultCallback: (p1: string, p2: string) => void): void;

	setMDMReportingEnabled(enabled: boolean): void;

	setPairedBluetoothDevice(uuid: string): void;

	setParserCompletion(parser: CMBResultParser, resultCallback: (p1: string, p2: string) => void): void;

	setPreviewContainerBelowStatusBar(belowStatusBar: boolean): void;

	setPreviewContainerFullScreenWithCompletion(resultCallback: (p1: string, p2: string) => void): void;

	setPreviewContainerPositionAndSizeXYWidthHeight(xp: number, yp: number, wp: number, hp: number): void;

	setPreviewOptions(previewOptions: CDMPreviewOption): void;

	setPreviewOverlayMode(overlayMode: number): void;

	setReadStringEncodingCompletion(readStringEncoding: CMBReadStringEncoding, completion: (p1: string, p2: string) => void): void;

	setStopScannerOnRotate(stopScannerOnRotate: boolean): void;

	setSymbologyEnabledCompletion(symbology: CMBSymbology, enabled: boolean, resultCallback: (p1: string, p2: string) => void): void;

	showMessage(message: string): void;

	startScanning(resultCallback: (p1: string, p2: string) => void): void;

	stopScanning(resultCallback: (p1: string, p2: string) => void): void;
}

declare class CCPObservers extends NSObject {

	static alloc(): CCPObservers; // inherited from NSObject

	static new(): CCPObservers; // inherited from NSObject

	delegate: CMBObserversDelegate;

	startObservingAppState(): void;

	startObservingCameraTrigger(): void;

	startObservingOrientationChange(): void;

	stopObserving(): void;
}

declare class CCPUtilities extends NSObject {

	static alloc(): CCPUtilities; // inherited from NSObject

	static checkCameraPermission(completion: (p1: boolean, p2: number) => void): void;

	static currentInterfaceOrientation(): UIInterfaceOrientation;

	static getDictionaryFromResult(readResult: CMBReadResult): NSDictionary<any, any>;

	static getImageFromSVGString(svg: string): UIImage;

	static getResultsJSONStringFromResultsKeyResultsKeySubResults(readResults: CMBReadResults, keyResults: string, keySubResults: string): string;

	static jsonStringFromDictionary(dictionary: NSDictionary<any, any>): string;

	static new(): CCPUtilities; // inherited from NSObject

	static requestCameraPermission(completion: (p1: boolean, p2: number) => void): void;
}

interface CMBObserversDelegate {

	appChangedActiveState?(active: boolean): void;

	interfaceChangedOrientation?(notification: NSNotification): void;

	scanningStateChanged?(isScanning: boolean): void;
}
declare var CMBObserversDelegate: {

	prototype: CMBObserversDelegate;
};

declare var CognexCrossPlatformVersionNumber: number;

declare var CognexCrossPlatformVersionString: interop.Reference<number>;
