import { CMBReaderConstants } from './cmbsdk-nativescript.common';
import { Observable } from "@nativescript/core";
export { CMBReaderConstants } from './cmbsdk-nativescript.common';
export class CMBReader extends Observable {
    constructor() {
        super();
        this.cmbReaderDelegate = null;
        this.cmbDelegate = null;
        this.cmbScanningStateDelegate = null;
        this.cmbDelegate = CMBReaderDeviceDelegateImpl.new();
        this.cmbDelegate.plugin = this;
        this.cmbScanningStateDelegate = CMBObserversDelegateImpl.new();
        this.cmbScanningStateDelegate.plugin = this;
        this.ccpBridge = CCPBridge.new();
        this.ccpBridge.ccpPluginDelegate = this.cmbDelegate;
        this.ccpBridge.ccpPluginScanningStateDelegate = this.cmbScanningStateDelegate;
    }
    loadScanner(deviceType) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.initReaderWithClassCallback(deviceType, () => {
                resolve(null);
            });
        });
    }
    connect() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.connect(this.createPluginStringResponse(resolve, reject));
        });
    }
    disconnect() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.disconnect(this.createPluginStringResponse(resolve, reject));
        });
    }
    startScanning() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.startScanning(this.createPluginStringResponse(resolve, reject));
        });
    }
    stopScanning() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.stopScanning(this.createPluginStringResponse(resolve, reject));
        });
    }
    registerSDK(key) {
        this.ccpBridge.registerSDK(key);
    }
    setCameraMode(cameraMode) {
        this.ccpBridge.setCameraMode(cameraMode);
    }
    setPreviewOptions(previewOptions) {
        this.ccpBridge.setPreviewOptions(previewOptions);
    }
    setPreviewOverlayMode(previewOverlayMode) {
        this.ccpBridge.setPreviewOverlayMode(previewOverlayMode);
    }
    enableCameraFlag(codeMask, flag) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.enableCameraFlagForMaskCompletion(flag, codeMask, this.createPluginStringResponse(resolve, reject));
        });
    }
    disableCameraFlag(codeMask, flag) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.disableCameraFlagForMaskCompletion(flag, codeMask, this.createPluginStringResponse(resolve, reject));
        });
    }
    setCameraParam(codeMask, param, value) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.setCameraParamParamValueForMaskCompletion(param, value, codeMask, this.createPluginStringResponse(resolve, reject));
        });
    }
    getCameraExposureCompensationRange() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.getCameraExposureCompensationRange(this.createPluginObjectResponse(resolve, reject));
        });
    }
    setCameraExposureCompensation(exposureCompensation) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.setCameraExposureCompensationCompletion(exposureCompensation, this.createPluginStringResponse(resolve, reject));
        });
    }
    loadCameraConfig() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.loadCameraConfig(this.createPluginStringResponse(resolve, reject));
        });
    }
    showToast(message) {
        this.ccpBridge.showMessage(message);
    }
    hideToast() {
        this.ccpBridge.hideMessage();
    }
    scanImageFromUri(uri) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.scanImageFromUriCompletion(uri, this.createPluginStringResponse(resolve, reject));
        });
    }
    scanImageFromBase64(base64) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.scanImageFromBase64Completion(base64, this.createPluginStringResponse(resolve, reject));
        });
    }
    setPreviewContainerPositionAndSize(x, y, w, h) {
        this.ccpBridge.setPreviewContainerPositionAndSizeXYWidthHeight(x, y, w, h);
    }
    setPreviewContainerBelowStatusBar(arg) {
        this.ccpBridge.setPreviewContainerBelowStatusBar(arg);
    }
    setPreviewContainerFullScreen() {
        new Promise((resolve, reject) => {
            this.ccpBridge.setPreviewContainerFullScreenWithCompletion(this.createPluginStringResponse(resolve, reject));
        });
    }
    setPairedBluetoothDevice(btDevice) {
        this.ccpBridge.setPairedBluetoothDevice(btDevice);
    }
    getPairedBluetoothDevice() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.getPairedBluetoothDevice(this.createPluginStringResponse(resolve, reject));
        });
    }
    setStopScannerOnRotate(arg) {
        this.ccpBridge.setStopScannerOnRotate(arg);
    }
    enableImage(arg) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.enableImageCompletion(arg, this.createPluginStringResponse(resolve, reject));
        });
    }
    enableImageGraphics(arg) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.enableImageGraphicsCompletion(arg, this.createPluginStringResponse(resolve, reject));
        });
    }
    setSymbologyEnabled(symbology, enable) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.setSymbologyEnabledCompletion(symbology, enable, this.createPluginStringResponse(resolve, reject));
        });
    }
    isSymbologyEnabled(symbology) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.isSymbologyEnabledCompletion(symbology, this.createPluginStringResponse(resolve, reject));
        });
    }
    setLightsOn(on) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.setLightsOnCompletion(on, this.createPluginStringResponse(resolve, reject));
        });
    }
    isLightsOn() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.isLightsOnWithCompletion(this.createPluginStringResponse(resolve, reject));
        });
    }
    sendCommand(commandString) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.sendCommandCompletion(commandString, this.createPluginStringResponse(resolve, reject));
        });
    }
    resetConfig() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.resetConfigWithCompletion(this.createPluginStringResponse(resolve, reject));
        });
    }
    beep() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.beep(this.createPluginStringResponse(resolve, reject));
        });
    }
    getDeviceBatteryLevel() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.getDeviceBatteryLevel(this.createPluginStringResponse(resolve, reject));
        });
    }
    getAvailability() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.getAvailability(this.createPluginStringResponse(resolve, reject));
        });
    }
    getConnectionState() {
        return new Promise((resolve, reject) => {
            this.ccpBridge.getConnectionState(this.createPluginStringResponse(resolve, reject));
        });
    }
    getSdkVersion() {
        return CDMDataManSystem.getVersion();
    }
    setParser(parserType) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.setParserCompletion(parserType, this.createPluginStringResponse(resolve, reject));
        });
    }
    setReadStringEncoding(readStringEncoding) {
        return new Promise((resolve, reject) => {
            this.ccpBridge.setReadStringEncodingCompletion(readStringEncoding, this.createPluginStringResponse(resolve, reject));
        });
    }
    setMDMReportingEnabled(enabled) {
        this.ccpBridge.setMDMReportingEnabled(enabled);
    }
    createMDMAuthCredentials(username, password, clientID, clientSecret) {
        this.ccpBridge.createMDMAuthCredentialsWithUsernamePasswordClientIDClientSecret(username, password, clientID, clientSecret);
    }
    createPluginStringResponse(resolve, reject) {
        return this.createPluginResponse(resolve, reject, false);
    }
    createPluginObjectResponse(resolve, reject) {
        return this.createPluginResponse(resolve, reject, true);
    }
    createPluginResponse(resolve, reject, createObject) {
        return (errorCode, payload) => {
            if (Number(errorCode) == 0) {
                if (createObject) {
                    resolve(JSON.parse(payload));
                }
                else {
                    resolve(payload);
                }
            }
            else {
                reject(payload);
            }
        };
    }
}
var CMBReaderDeviceDelegateImpl = /** @class */ (function (_super) {
    __extends(CMBReaderDeviceDelegateImpl, _super);
    function CMBReaderDeviceDelegateImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CMBReaderDeviceDelegateImpl.new = function () {
        return _super.new.call(this);
    };
    CMBReaderDeviceDelegateImpl.prototype.availabilityDidChangeOfReader = function (reader) {
        this.plugin.notify({ eventName: CMBReaderConstants.EVENTS.AvailabilityChanged, object: this.plugin, data: reader.availability });
    };
    CMBReaderDeviceDelegateImpl.prototype.connectionStateDidChangeOfReader = function (reader) {
        this.plugin.notify({ eventName: CMBReaderConstants.EVENTS.ConnectionStateChanged, object: this.plugin, data: reader.connectionState });
    };
    CMBReaderDeviceDelegateImpl.prototype.didReceiveReadResultFromReaderResults = function (reader, readResults) {
        var jsonString = CCPUtilities.getResultsJSONStringFromResultsKeyResultsKeySubResults(readResults, "results", "subResults");
        this.plugin.notify({ eventName: CMBReaderConstants.EVENTS.ReadResultReceived, object: this.plugin, data: JSON.parse(jsonString) });
    };
    CMBReaderDeviceDelegateImpl.ObjCProtocols = [CMBReaderDeviceDelegate];
    return CMBReaderDeviceDelegateImpl;
}(UIResponder));
var CMBObserversDelegateImpl = /** @class */ (function (_super) {
    __extends(CMBObserversDelegateImpl, _super);
    function CMBObserversDelegateImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CMBObserversDelegateImpl.new = function () {
        return _super.new.call(this);
    };
    CMBObserversDelegateImpl.prototype.scanningStateChanged = function (isScanning) {
        this.plugin.notify({ eventName: CMBReaderConstants.EVENTS.ScanningStateChanged, object: this.plugin, data: isScanning });
    };
    CMBObserversDelegateImpl.ObjCProtocols = [CMBObserversDelegate];
    return CMBObserversDelegateImpl;
}(UIResponder));
//# sourceMappingURL=cmbsdk-nativescript.ios.js.map