
declare const enum CDMCameraMode {

	kCDMCameraModeNoAimer = 0,

	kCDMCameraModePassiveAimer = 1,

	kCDMCameraModeFrontCamera = 2
}

declare const enum CDMConnectionState {

	kCDMConnectionStateDisconnected = 0,

	kCDMConnectionStateConnecting = 1,

	kCDMConnectionStateConnected = 2,

	kCDMConnectionStateDisconnecting = 3
}

declare class CDMDataManSystem extends NSObject {

	static alloc(): CDMDataManSystem; // inherited from NSObject

	static dataManSystemOfExternalAccessoryWithDelegate(delegate: CDMDataManSystemDelegate): CDMDataManSystem;

	static dataManSystemWithAccessoryDelegate(accessory: EAAccessory, delegate: CDMDataManSystemDelegate): CDMDataManSystem;

	static dataManSystemWithCameraModePreviewOptionsDelegate(cameraMode: CDMCameraMode, previewOptions: CDMPreviewOption, delegate: CDMDataManSystemDelegate): CDMDataManSystem;

	static dataManSystemWithCameraModePreviewOptionsNullablePreviewViewDelegate(cameraMode: CDMCameraMode, previewOptions: CDMPreviewOption, previewView: UIView, delegate: CDMDataManSystemDelegate): CDMDataManSystem;

	static dataManSystemWithCameraModePreviewOptionsNullablePreviewViewRegistrationKeyCustomDataDelegate(cameraMode: CDMCameraMode, previewOptions: CDMPreviewOption, previewView: UIView, registrationKey: string, customData: string, delegate: CDMDataManSystemDelegate): CDMDataManSystem;

	static dataManSystemWithCameraModePreviewOptionsNullablePreviewViewRegistrationKeyDelegate(cameraMode: CDMCameraMode, previewOptions: CDMPreviewOption, previewView: UIView, registrationKey: string, delegate: CDMDataManSystemDelegate): CDMDataManSystem;

	static dataManSystemWithHostnamePortDelegate(hostname: string, port: number, delegate: CDMDataManSystemDelegate): CDMDataManSystem;

	static datamanSystemWithBluetoothPeripheralPsmDelegate(peripheral: CBPeripheral, psm: number, delegate: CDMDataManSystemDelegate): CDMDataManSystem;

	static getVersion(): string;

	static new(): CDMDataManSystem; // inherited from NSObject

	MDMReportingEnabled: boolean;

	readonly connected: boolean;

	readonly connectionState: CDMConnectionState;

	defaultMDMAuthCredentials: MDMAuthCredentials;

	delegate: CDMDataManSystemDelegate;

	readonly deviceClass: DataManDeviceClass;

	readonly heartbeatEnabled: boolean;

	readonly liveImageEnabled: boolean;

	resultTypes: CDMResultTypes;

	timeout: number;

	acceptIncomingConnection(accept: boolean): void;

	connect(): boolean;

	connectWithUsernamePassword(username: string, password: string): boolean;

	disableHeartbeat(): void;

	disableLiveImage(): void;

	disconnect(): void;

	enableHeartbeatWithInterval(interval: number): void;

	enableLiveImageWithFormatImageSizeImageQualityCallback(imageFormat: CDMImageFormat, imageSize: CDMImageSize, quality: CDMImageQuality, callback: (p1: UIImage, p2: CDMResponse) => void): void;

	getCameraExposureCompensationRangeWithCompletion(completionBlock: (p1: NSArray<number>, p2: NSError) => void): void;

	loadCameraConfig(completionBlock: (p1: NSError) => void): void;

	sendBatchCommandsCompleted(commands: NSArray<any> | any[], complete: () => void): boolean;

	sendCommand(command: string): boolean;

	sendCommandWithCallback(command: string, callback: (p1: CDMResponse) => void): boolean;

	sendCommandWithDataTimeoutExpectBinaryResponseCallback(command: string, data: NSData, timeout: number, expectBinaryResponse: boolean, callback: (p1: CDMResponse) => void): boolean;

	setCameraExposureCompensationCompletion(exposureCompensation: number, completionBlock: (p1: NSError) => void): void;

	setCameraPreviewContainerCompletion(previewContainer: UIView, completionBlock: (p1: NSError) => void): void;
}

interface CDMDataManSystemDelegate extends NSObjectProtocol {

	dataManSystemDidConnect(dataManSystem: CDMDataManSystem): void;

	dataManSystemDidDisconnectWithError(dataManSystem: CDMDataManSystem, error: NSError): void;

	dataManSystemDidMissHeartbeatResponse?(dataManSystem: CDMDataManSystem): void;

	dataManSystemDidReceiveImageGraphicsWithId?(dataManSystem: CDMDataManSystem, graphics: NSData, resultId: number): void;

	dataManSystemDidReceiveImageWithId(dataManSystem: CDMDataManSystem, image: UIImage, resultId: number): void;

	dataManSystemDidReceiveOffProtocolByte?(dataManSystem: CDMDataManSystem, byte: number): void;

	dataManSystemDidReceiveReadStringWithId(dataManSystem: CDMDataManSystem, readString: string, resultId: number): void;

	dataManSystemDidReceiveStatusEvent?(dataManSystem: CDMDataManSystem, data: NSData): void;

	dataManSystemDidReceiveTrainingResult?(dataManSystem: CDMDataManSystem, trainingResult: string): void;

	dataManSystemDidReceiveTransferProgressTotalSizeSizeTransferred?(dataManSystem: CDMDataManSystem, direction: CDMTransferDirection, total: number, size: number): void;

	dataManSystemDidReceiveXmlResultWithId?(dataManSystem: CDMDataManSystem, xml: NSData, resultId: number): void;

	dataManSystemDidReceiveXmlStatistics?(dataManSystem: CDMDataManSystem, xml: NSData): void;
}
declare var CDMDataManSystemDelegate: {

	prototype: CDMDataManSystemDelegate;
};

declare class CDMEADiscoverer extends NSObject {

	static alloc(): CDMEADiscoverer; // inherited from NSObject

	static new(): CDMEADiscoverer; // inherited from NSObject

	static sharedDiscoverer(): any;

	compatibleAccessories(): NSArray<any>;

	startDiscovery(): void;

	stopDiscovery(): void;
}

declare const enum CDMImageFormat {

	kCDMImageFormatBitmap = 0,

	kCDMImageFormatJpeg = 1
}

declare const enum CDMImageQuality {

	kCDMImageQualityLow = 10,

	kCDMImageQualityMedium = 50,

	kCDMImageQualityHigh = 90
}

declare const enum CDMImageSize {

	kCDMImageSizeFull = 0,

	kCDMImageSizeQuarter = 1,

	kCDMImageSizeSixteenth = 2,

	kCDMImageSizeSixtyFourth = 3
}

declare const enum CDMPreviewOption {

	kCDMPreviewOptionDefaults = 0,

	kCDMPreviewOptionNoZoomBtn = 1,

	kCDMPreviewOptionNoIllumBtn = 2,

	kCDMPreviewOptionHwTrigger = 4,

	kCDMPreviewOptionPaused = 8,

	kCDMPreviewOptionAlwaysShow = 16,

	kCDMPreviewOptionHighResolution = 32,

	kCDMPreviewOptionHighFrameRate = 64,

	kCDMPreviewOptionShowCloseBtn = 128,

	kCDMPreviewOptionKeepPreviewInPausedState = 256
}

declare class CDMResponse extends NSObject {

	static alloc(): CDMResponse; // inherited from NSObject

	static new(): CDMResponse; // inherited from NSObject

	readonly binaryPayload: NSData;

	readonly payload: string;

	readonly responseId: number;

	readonly status: number;

	constructor(o: { responseId: number; status: number; payload: string; binaryPayload: NSData; });

	initWithResponseIdStatusPayloadBinaryPayload(responseId: number, status: number, payload: string, binaryPayload: NSData): this;
}

declare const enum CDMResultTypes {

	kCDMResultTypeNone = 0,

	kCDMResultTypeReadString = 1,

	kCDMResultTypeReadXml = 2,

	kCDMResultTypeXmlStatistics = 4,

	kCDMResultTypeImage = 8,

	kCDMResultTypeImageGraphics = 16,

	kCDMResultTypeTrainingResults = 32,

	kCDMResultTypeCodeQualityData = 64,

	kCDMResultTypeXmlContent = 128
}

declare const enum CDMTransferDirection {

	kCDMTransferDirectionIncoming = 0,

	kCDMTransferDirectionOutgoing = 1
}

declare const enum CMBConnectionState {

	Disconnected = 0,

	Connecting = 1,

	Connected = 2,

	Disconnecting = 3,

	Unavailable = 4
}

declare class CMBReadResult extends NSObject {

	static alloc(): CMBReadResult; // inherited from NSObject

	static new(): CMBReadResult; // inherited from NSObject

	XML: NSData;

	goodRead: boolean;

	image: UIImage;

	imageGraphics: NSData;

	isGS1: boolean;

	parsedJSON: string;

	parsedText: string;

	readString: string;

	symbology: CMBSymbology;
}

declare class CMBReadResults extends NSObject {

	static alloc(): CMBReadResults; // inherited from NSObject

	static new(): CMBReadResults; // inherited from NSObject

	readonly XML: string;

	readonly readResults: NSArray<CMBReadResult>;

	readonly subReadResults: NSArray<CMBReadResult>;
}

declare const enum CMBReadStringEncoding {

	Auto = 0,

	UTF_8 = 1,

	UTF_16 = 2,

	UTF_32 = 3,

	ISO_8859_1 = 4,

	ISO_8859_2 = 5,

	Shift_JIS = 6,

	US_ASCII = 7,

	US_ASCII_SHOW_NON_PRINTABLE = 8
}

declare const enum CMBReaderAvailibility {

	Unknown = 0,

	Available = 1,

	Unavailable = 2
}

declare class CMBReaderDevice extends NSObject {

	static alloc(): CMBReaderDevice; // inherited from NSObject

	static new(): CMBReaderDevice; // inherited from NSObject

	static readerOfBluetoothPeripheralPsm(peripheral: CBPeripheral, psm: number): CMBReaderDevice;

	static readerOfDeviceCameraWithCameraModePreviewOptions(cameraMode: CDMCameraMode, previewOptions: CDMPreviewOption): CMBReaderDevice;

	static readerOfDeviceCameraWithCameraModePreviewOptionsPreviewView(cameraMode: CDMCameraMode, previewOptions: CDMPreviewOption, previewContainer: UIView): CMBReaderDevice;

	static readerOfDeviceCameraWithCameraModePreviewOptionsPreviewViewRegistrationKey(cameraMode: CDMCameraMode, previewOptions: CDMPreviewOption, previewContainer: UIView, registrationKey: string): CMBReaderDevice;

	static readerOfDeviceCameraWithCameraModePreviewOptionsPreviewViewRegistrationKeyCustomData(cameraMode: CDMCameraMode, previewOptions: CDMPreviewOption, previewContainer: UIView, registrationKey: string, customData: string): CMBReaderDevice;

	static readerOfMXDevice(): CMBReaderDevice;

	static readerWithBTConnectedDataManSystem(dataManSystem: CDMDataManSystem): CMBReaderDevice;

	SVGResultEnabled: boolean;

	readonly availability: CMBReaderAvailibility;

	readonly connectionState: CMBConnectionState;

	delegate: CMBReaderDeviceDelegate;

	readonly deviceClass: DataManDeviceClass;

	imageResultEnabled: boolean;

	parser: CMBResultParser;

	readStringEncoding: CMBReadStringEncoding;

	beep(): void;

	connectWithCompletion(completionBlock: (p1: NSError) => void): void;

	dataManSystem(): CDMDataManSystem;

	disconnect(): void;

	getCameraExposureCompensationRangeWithCompletion(completionBlock: (p1: NSArray<number>, p2: NSError) => void): void;

	getDeviceBatteryLevelWithCompletion(completionBlock: (p1: number, p2: NSError) => void): void;

	getLightsStateWithCompletion(completionBlock: (p1: boolean, p2: NSError) => void): void;

	isSymbologyEnabledCompletion(symbology: CMBSymbology, completionBlock: (p1: boolean, p2: NSError) => void): void;

	loadCameraConfig(completionBlock: (p1: NSError) => void): void;

	resetConfigWithCompletion(completionBlock: (p1: NSError) => void): void;

	setCameraExposureCompensationCompletion(exposureCompensation: number, completionBlock: (p1: NSError) => void): void;

	setCameraPreviewContainerCompletion(previewContainer: UIView, completionBlock: (p1: NSError) => void): void;

	setLightsONCompletion(on: boolean, completionBlock: (p1: NSError) => void): void;

	setSymbologyEnabledCompletion(symbology: CMBSymbology, enabled: boolean, completionBlock: (p1: NSError) => void): void;

	startScanning(): void;

	stopScanning(): void;
}

interface CMBReaderDeviceDelegate extends NSObjectProtocol {

	availabilityDidChangeOfReader?(reader: CMBReaderDevice): void;

	connectionStateDidChangeOfReader?(reader: CMBReaderDevice): void;

	didReceiveReadResultFromReaderResults?(reader: CMBReaderDevice, readResults: CMBReadResults): void;
}
declare var CMBReaderDeviceDelegate: {

	prototype: CMBReaderDeviceDelegate;
};

declare const enum CMBResultParser {

	None = 0,

	Auto = 1,

	AAMVA = 2,

	GS1 = 3,

	HIBC = 4,

	ISBT128 = 5,

	IUID = 6,

	SCM = 7
}

declare const enum CMBSymbology {

	Unknown = 0,

	DataMatrix = 1,

	QR = 2,

	C128 = 3,

	UpcEan = 4,

	C11 = 5,

	C39 = 6,

	C93 = 7,

	I2o5 = 8,

	CodaBar = 9,

	EanUcc = 10,

	PharmaCode = 11,

	Maxicode = 12,

	Pdf417 = 13,

	Micropdf417 = 14,

	Databar = 15,

	Planet = 16,

	Postnet = 17,

	FourStateJap = 18,

	FourStateAus = 19,

	FourStateUpu = 20,

	FourStateImb = 21,

	Vericode = 22,

	Rpc = 23,

	Msi = 24,

	Azteccode = 25,

	Dotcode = 26,

	C25 = 27,

	C39ConvertToC32 = 28,

	Ocr = 29,

	FourStateRmc = 30,

	Telepen = 31
}

declare class CMBUtility extends NSObject {

	static alloc(): CMBUtility; // inherited from NSObject

	static new(): CMBUtility; // inherited from NSObject

	static xmlStringFromDataPrettyPrint(xmlData: NSData, prettyPrint: boolean): string;
}

declare const enum DataManDeviceClass {

	MX = 0,

	Network = 1,

	PhoneCamera = 2,

	BT_L2CAP = 3
}

declare class MDMAuthCredentials extends NSObject {

	static alloc(): MDMAuthCredentials; // inherited from NSObject

	static new(): MDMAuthCredentials; // inherited from NSObject

	clientID: string;

	clientSecret: string;

	password: string;

	tenantCode: string;

	username: string;
}

declare function MWB_cleanupLib(): number;

declare function MWB_createRegionsFromTiles(tilesX: number, tilesY: number, overlap: number, regionsData: interop.Pointer | interop.Reference<number>): number;

declare function MWB_disableCode(codeMask: number): number;

declare function MWB_disableFlag(codeMask: number, flag: number): number;

declare function MWB_disableSubcode(codeMask: number, subMask: number): number;

declare function MWB_enableCode(codeMask: number): number;

declare function MWB_enableFlag(codeMask: number, flag: number): number;

declare function MWB_enableSubcode(codeMask: number, subMask: number): number;

declare function MWB_getActiveCodes(): number;

declare function MWB_getActiveSubcodes(codeMask: number): number;

declare function MWB_getBarcodeLocation(points: interop.Pointer | interop.Reference<number>): number;

declare function MWB_getDeviceID(): string;

declare function MWB_getDirection(): number;

declare function MWB_getFlags(codeMask: number): number;

declare function MWB_getLastType(): number;

declare function MWB_getLibVersion(): number;

declare function MWB_getLibVersionText(): string;

declare function MWB_getLicenseString(): string;

declare function MWB_getParam(codeMask: number, paramId: number): number;

declare function MWB_getResultType(): number;

declare function MWB_getScanningRect(codeMask: number, left: interop.Pointer | interop.Reference<number>, top: interop.Pointer | interop.Reference<number>, width: interop.Pointer | interop.Reference<number>, height: interop.Pointer | interop.Reference<number>): number;

declare function MWB_getSupportedCodes(): number;

declare function MWB_getTargetRect(left: interop.Pointer | interop.Reference<number>, top: interop.Pointer | interop.Reference<number>, width: interop.Pointer | interop.Reference<number>, height: interop.Pointer | interop.Reference<number>): number;

declare function MWB_isLastGS1(): number;

declare function MWB_registerSDK(key: string | interop.Pointer | interop.Reference<any>): number;

declare function MWB_registerSDKCustom(key: string | interop.Pointer | interop.Reference<any>, customData: string | interop.Pointer | interop.Reference<any>): number;

declare function MWB_scanGrayscaleImage(pp_image: string | interop.Pointer | interop.Reference<any>, lenX: number, lenY: number, pp_data: interop.Pointer | interop.Reference<string>): number;

declare function MWB_scanGrayscaleRegions(pp_image: string | interop.Pointer | interop.Reference<any>, lenX: number, lenY: number, regionsData: interop.Pointer | interop.Reference<number>, numberOfRegions: number, maxThreads: number, pp_data: interop.Pointer | interop.Reference<string>): number;

declare function MWB_setActiveCodes(codeMask: number): number;

declare function MWB_setActiveSubcodes(codeMask: number, subMask: number): number;

declare function MWB_setCodePriority(codeMask: number, priority: number): number;

declare function MWB_setDirection(direction: number): number;

declare function MWB_setDuplicate(barcode: string | interop.Pointer | interop.Reference<any>, length: number): void;

declare function MWB_setDuplicatesTimeout(timeout: number): number;

declare function MWB_setFlags(codeMask: number, flags: number): number;

declare function MWB_setLevel(level: number): number;

declare function MWB_setMinLength(codeMask: number, minLength: number): number;

declare function MWB_setParam(codeMask: number, paramId: number, paramValue: number): number;

declare function MWB_setResultType(resultType: number): number;

declare function MWB_setScanningRect(codeMask: number, left: number, top: number, width: number, height: number): number;

declare function MWB_setTargetRect(left: number, top: number, width: number, height: number): number;

declare function MWB_validateVIN(vin: string | interop.Pointer | interop.Reference<any>, length: number): number;

declare class MWLocation extends NSObject {

	static alloc(): MWLocation; // inherited from NSObject

	static new(): MWLocation; // inherited from NSObject

	p1: CGPoint;

	p2: CGPoint;

	p3: CGPoint;

	p4: CGPoint;

	readonly points: interop.Pointer | interop.Reference<CGPoint>;

	constructor(o: { points: number; y1: number; x2: number; y2: number; x3: number; y3: number; x4: number; y4: number; });

	initWithPointsY1X2Y2X3Y3X4Y4(x1: number, y1: number, x2: number, y2: number, x3: number, y3: number, x4: number, y4: number): this;
}

declare class MWOverlay extends NSObject {

	static addToPreviewLayer(videoPreviewLayer: AVCaptureVideoPreviewLayer): void;

	static addViewFinderToViewIsFullScreen(scannerView: UIView, fullScreen: boolean): void;

	static alloc(): MWOverlay; // inherited from NSObject

	static getLocationLineColor(): number;

	static getOverlayMode(): number;

	static getTargetRectLineColor(): number;

	static isAttached(): boolean;

	static new(): MWOverlay; // inherited from NSObject

	static removeFromPreviewLayer(): void;

	static setBlinkingLineAlpha(value: number): void;

	static setBlinkingLineRGBColor(value: number): void;

	static setBlinkingLineUIColor(value: UIColor): void;

	static setBlinkingLineVisible(value: boolean): void;

	static setBlinkingLineWidth(value: number): void;

	static setBlinkingSpeed(value: number): void;

	static setLocationLineRGBColor(value: number): void;

	static setLocationLineUIColor(value: UIColor): void;

	static setLocationLineWidth(value: number): void;

	static setOverlayMode(overlayMode: number): void;

	static setPauseMode(pMode: PauseMode): void;

	static setPaused(paused: boolean): void;

	static setTargetRectLineAlpha(value: number): void;

	static setTargetRectLineRGBColor(value: number): void;

	static setTargetRectLineUIColor(value: UIColor): void;

	static setTargetRectLineWidth(value: number): void;

	static setTargetRectVisible(value: boolean): void;

	static setViewportAlpha(value: number): void;

	static setViewportLineAlpha(value: number): void;

	static setViewportLineRGBColor(value: number): void;

	static setViewportLineUIColor(value: UIColor): void;

	static setViewportLineWidth(value: number): void;

	static setViewportVisible(value: boolean): void;

	static showLocationImageWidthImageHeight(points: interop.Pointer | interop.Reference<CGPoint>, width: number, height: number): void;

	static showLocationsCountImageWidthImageHeight(points: interop.Pointer | interop.Reference<CGPoint>, count: number, width: number, height: number): void;

	static updateOverlay(): void;
}

declare function MWP_getFormattedText(parser_type: number, p_input: string | interop.Pointer | interop.Reference<any>, inputLength: number, pp_output: interop.Pointer | interop.Reference<string>): number;

declare function MWP_getJSON(parser_type: number, p_input: string | interop.Pointer | interop.Reference<any>, inputLength: number, pp_output: interop.Pointer | interop.Reference<string>): number;

declare function MWP_getSupportedParsers(): number;

declare function MWP_registerParser(parserMask: number, userName: string | interop.Pointer | interop.Reference<any>, key: string | interop.Pointer | interop.Reference<any>): number;

declare class MWResult extends NSMutableDictionary<NSObject, NSObject> {

	static alloc(): MWResult; // inherited from NSObject

	static dictionary(): MWResult; // inherited from NSDictionary

	static dictionaryWithCapacity(numItems: number): MWResult; // inherited from NSMutableDictionary

	static dictionaryWithDictionary(dict: NSDictionary<KeyType, ObjectType>): MWResult; // inherited from NSDictionary

	static dictionaryWithObjectForKey(object: ObjectType, key: KeyType): MWResult; // inherited from NSDictionary

	static dictionaryWithObjectsAndKeys(firstObject: any): MWResult; // inherited from NSDictionary

	static dictionaryWithObjectsForKeys(objects: NSArray<ObjectType> | ObjectType[], keys: NSArray<KeyType> | KeyType[]): MWResult; // inherited from NSDictionary

	static dictionaryWithObjectsForKeysCount(objects: interop.Reference<ObjectType>, keys: interop.Reference<KeyType>, cnt: number): MWResult; // inherited from NSDictionary

	static new(): MWResult; // inherited from NSObject

	barcodeHeight: number;

	barcodeWidth: number;

	bytes: string;

	bytesLength: number;

	encryptedResult: string;

	imageHeight: number;

	imageWidth: number;

	isGS1: boolean;

	isKanji: boolean;

	locationPoints: MWLocation;

	moduleSizeX: number;

	moduleSizeY: number;

	modulesCountX: number;

	modulesCountY: number;

	pdfCodewords: interop.Pointer | interop.Reference<number>;

	pdfColumnsCount: number;

	pdfECLevel: number;

	pdfIsTruncated: boolean;

	pdfRowsCount: number;

	skew: number;

	subtype: number;

	text: string;

	textEncoding: string;

	type: number;

	typeName: string;
}

declare class MWResults extends NSObject {

	static alloc(): MWResults; // inherited from NSObject

	static new(): MWResults; // inherited from NSObject

	count: number;

	results: NSMutableArray<any>;

	version: number;

	constructor(o: { buffer: string | interop.Pointer | interop.Reference<any>; });

	initWithBuffer(buffer: string | interop.Pointer | interop.Reference<any>): this;

	resultAtIntex(index: number): MWResult;
}

declare const enum OverlayMode {

	M_CMB = 0,

	M_LEGACY = 1
}

declare const enum PauseMode {

	M_NONE = 0,

	M_PAUSE = 1,

	M_STOP_BLINKING = 2
}

declare var cmbSDKVersionNumber: number;

declare var cmbSDKVersionString: interop.Reference<number>;

declare const enum res_types {

	FOUND_NONE = 0,

	FOUND_DM = 1,

	FOUND_39 = 2,

	FOUND_RSS_14 = 3,

	FOUND_RSS_14_STACK = 4,

	FOUND_RSS_LIM = 5,

	FOUND_RSS_EXP = 6,

	FOUND_EAN_13 = 7,

	FOUND_EAN_8 = 8,

	FOUND_UPC_A = 9,

	FOUND_UPC_E = 10,

	FOUND_128 = 11,

	FOUND_PDF = 12,

	FOUND_QR = 13,

	FOUND_AZTEC = 14,

	FOUND_25_INTERLEAVED = 15,

	FOUND_25_STANDARD = 16,

	FOUND_93 = 17,

	FOUND_CODABAR = 18,

	FOUND_DOTCODE = 19,

	FOUND_128_GS1 = 20,

	FOUND_ITF14 = 21,

	FOUND_11 = 22,

	FOUND_MSI = 23,

	FOUND_25_IATA = 24,

	FOUND_25_MATRIX = 25,

	FOUND_25_COOP = 26,

	FOUND_25_INVERTED = 27,

	FOUND_QR_MICRO = 28,

	FOUND_MAXICODE = 29,

	FOUND_POSTNET = 30,

	FOUND_PLANET = 31,

	FOUND_IMB = 32,

	FOUND_ROYALMAIL = 33,

	FOUND_MICRO_PDF = 34,

	FOUND_32 = 35,

	FOUND_AUSTRALIAN = 36,

	FOUND_TELEPEN = 37
}
