import { Observable } from '@nativescript/core';
export class CMBReaderConstants {
}
CMBReaderConstants.DEVICE_TYPE = {
    MXReader: 0,
    Camera: 2,
    Bluetooth: 3
};
CMBReaderConstants.SYMBOLOGY = {
    Unknown: 0,
    DataMatrix: 1,
    QR: 2,
    C128: 3,
    UpcEan: 4,
    C11: 5,
    C39: 6,
    C93: 7,
    I2o5: 8,
    CodaBar: 9,
    EanUcc: 10,
    PharmaCode: 11,
    Maxicode: 12,
    Pdf417: 13,
    Micropdf417: 14,
    Databar: 15,
    Planet: 16,
    Postnet: 17,
    FourStateJap: 18,
    FourStateAus: 19,
    FourStateUpu: 20,
    FourStateImb: 21,
    Vericode: 22,
    Rpc: 23,
    Msi: 24,
    Azteccode: 25,
    Dotcode: 26,
    C25: 27,
    C39ConvertToC32: 28,
    Ocr: 29,
    FourStateRm: 30,
    Telepen: 30
};
CMBReaderConstants.SYMBOLOGY_NAME = {
    Unknown: "Unknown",
    DataMatrix: "DataMatrix",
    QR: "QR",
    C128: "C128",
    UpcEan: "UpcEan",
    C11: "C11",
    C39: "C39",
    C93: "C93",
    I2o5: "I2o5",
    CodaBar: "CodaBar",
    EanUcc: "EanUcc",
    PharmaCode: "PharmaCode",
    Maxicode: "Maxicode",
    Pdf417: "Pdf417",
    Micropdf417: "Micropdf417",
    Databar: "Databar",
    Planet: "Planet",
    Postnet: "Postnet",
    FourStateJap: "FourStateJap",
    FourStateAus: "FourStateAus",
    FourStateUpu: "FourStateUpu",
    FourStateImb: "FourStateImb",
    Vericode: "Vericode",
    Rpc: "Rpc",
    Msi: "Msi",
    Azteccode: "Azteccode",
    Dotcode: "Dotcode",
    C25: "C25",
    C39ConvertToC32: "C39ConvertToC32",
    Ocr: "Ocr",
    FourStateRm: "FourStateRm",
    Telepen: "Telepen"
};
CMBReaderConstants.AVAILABILITY = {
    Unknown: 0,
    Available: 1,
    Unavailable: 2
};
CMBReaderConstants.CONNECTION_STATE = {
    Disconnected: 0,
    Connecting: 1,
    Connected: 2,
    Disconnecting: 3,
    Unavailable: 4
};
CMBReaderConstants.CAMERA_MODE = {
    NoAimer: 0,
    PassiveAimer: 1,
    FrontCamera: 2
};
CMBReaderConstants.OVERLAY_MODE = {
    OM_CMB: 0,
    OM_LEGACY: 1,
};
CMBReaderConstants.CAMERA_PREVIEW_OPTION = {
    Defaults: 0,
    NoZoomBtn: 1,
    NoIllumBtn: 2,
    HwTrigger: 4,
    Paused: 8,
    AlwaysShow: 16,
    HighResolution: 32,
    HighFramerate: 64,
    ShowCloseButton: 128,
    KeepPreviewInPausedState: 256,
    QHDResolution: 512
};
CMBReaderConstants.PARSERS = {
    NONE: 0,
    AUTO: 1,
    AAMVA: 2,
    GS1: 3,
    HIBC: 4,
    ISBT128: 5,
    IUID: 6,
    SCM: 7
};
CMBReaderConstants.READSTRING_ENCODING = {
    AUTO: 0,
    UTF_8: 1,
    UTF_16: 2,
    UTF_32: 3,
    ISO_8859_1: 4,
    ISO_8859_2: 5,
    Shift_JIS: 6,
    US_ASCII: 7,
    US_ASCII_SHOW_NON_PRINTABLE: 8
};
CMBReaderConstants.EVENTS = {
    ReadResultReceived: "didReceiveReadResultFromReaderEvent",
    AvailabilityChanged: "availabilityDidChangeOfReaderEvent",
    ConnectionStateChanged: "connectionStateDidChangeOfReaderEvent",
    ScanningStateChanged: "scanningStateChangedEvent",
};
//# sourceMappingURL=cmbsdk-nativescript.common.js.map