import { Observable } from "@nativescript/core";
export { CMBReaderConstants } from './cmbsdk-nativescript.common';
export declare class CMBReader extends Observable {
    private cmbReaderDelegate;
    private ccpBridge;
    private cmbDelegate;
    private cmbScanningStateDelegate;
    constructor();
    loadScanner(deviceType: number): Promise<any>;
    connect(): Promise<any>;
    disconnect(): Promise<any>;
    startScanning(): Promise<any>;
    stopScanning(): Promise<any>;
    registerSDK(key: string): void;
    setCameraMode(cameraMode: number): void;
    setPreviewOptions(previewOptions: number): void;
    setPreviewOverlayMode(previewOverlayMode: number): void;
    enableCameraFlag(codeMask: number, flag: number): Promise<any>;
    disableCameraFlag(codeMask: number, flag: number): Promise<any>;
    setCameraParam(codeMask: number, param: number, value: number): Promise<any>;
    getCameraExposureCompensationRange(): Promise<any>;
    setCameraExposureCompensation(exposureCompensation: number): Promise<any>;
    loadCameraConfig(): Promise<any>;
    showToast(message: string): void;
    hideToast(): void;
    scanImageFromUri(uri: string): Promise<any>;
    scanImageFromBase64(base64: string): Promise<any>;
    setPreviewContainerPositionAndSize(x: number, y: number, w: number, h: number): void;
    setPreviewContainerBelowStatusBar(arg: boolean): void;
    setPreviewContainerFullScreen(): void;
    setPairedBluetoothDevice(btDevice: string): void;
    getPairedBluetoothDevice(): Promise<any>;
    setStopScannerOnRotate(arg: boolean): void;
    enableImage(arg: boolean): Promise<any>;
    enableImageGraphics(arg: boolean): Promise<any>;
    setSymbologyEnabled(symbology: number, enable: boolean): Promise<any>;
    isSymbologyEnabled(symbology: number): Promise<any>;
    setLightsOn(on: boolean): Promise<any>;
    isLightsOn(): Promise<any>;
    sendCommand(commandString: string): Promise<any>;
    resetConfig(): Promise<any>;
    beep(): Promise<any>;
    getDeviceBatteryLevel(): Promise<any>;
    getAvailability(): Promise<any>;
    getConnectionState(): Promise<any>;
    getSdkVersion(): string;
    setParser(parserType: number): Promise<any>;
    setReadStringEncoding(readStringEncoding: number): Promise<any>;
    setMDMReportingEnabled(enabled: boolean): void;
    createMDMAuthCredentials(username: string, password: string, clientID: string, clientSecret: string): void;
    private createPluginStringResponse;
    private createPluginObjectResponse;
    private createPluginResponse;
}
