//
//  SettingsView.swift
//  cmbSDKToolkitSample
//
//

import SwiftUI

struct SettingsView: View {
    
    @Environment(\.dismiss) private var dismiss
    @EnvironmentObject var readerManager: ReaderManager
    @ObservedObject private var readerConfig: ReaderConfig
    
    init(_ readerConfig: ReaderConfig) {
        self.readerConfig = readerConfig
    }
    
    var body: some View {
        NavigationStack {
            List {
                Section("Symbology Settings") {
                    NavigationLink("Symbologies") {
                        SymbologySettingsView(readerManager.readerDevice!.dataManSystem())
                            .navigationTitle("Symbology Settings")
                    }
                }
                Section("Reader Settings") {
                    Toggle("Beep on Success", isOn: $readerConfig.beepOnSuccess)
                    Toggle("Show Image", isOn: $readerConfig.showImage)
                }
            }
            .navigationTitle("Settings")
            .toolbar {
                Button {
                    dismiss()
                } label: {
                    Text("Done")
                }
            }
        }
    }
}
