//
//  SymbologySettingsView.swift
//  cmbSDKToolkitSample
//
//

import SwiftUI
import cmbSDKToolkit
import cmbSDK

struct SymbologySettingsView: UIViewControllerRepresentable {
    
    @EnvironmentObject var appState: AppState
    private var datamanSystem: CDMDataManSystem
    
    init(_ datamanSystem: CDMDataManSystem) {
        self.datamanSystem = datamanSystem
    }
    
    func makeUIViewController(context: Context) -> UIViewController {
        let symbologySettingsVC = SymbologySettingsTVC(dataManSystem: self.datamanSystem, style: UITableView.Style.grouped)        
        return symbologySettingsVC
    }

    func updateUIViewController(_ uiViewController: UIViewController, context: Context) {
        //nothing to do
    }
}
