//
//  Settings.swift
//  cmbSDKToolkitSample
//
//

import Foundation
import SwiftUI

struct Settings: Codable {
    
    private static let SettingsKey = "SettingsKey"
    var pairedDeviceUUID: UUID? { didSet { self.save() } }
    
    enum CodingKeys: String, CodingKey {
        case pairedDeviceUUID
    }
    
    func save() {
        let data = try! PropertyListEncoder().encode(self)
        UserDefaults.standard.set(data, forKey: Self.SettingsKey)
    }
    
    static func saved() -> Settings {
        guard let data = UserDefaults.standard.data(forKey: self.SettingsKey) else {
            let defaultSettings = Settings()
            defaultSettings.save()
            return defaultSettings
        }
        let savedSettings = try! PropertyListDecoder().decode(Self.self, from: data)
        return savedSettings
    }
}


