//
//  cmbSDKToolkitSampleAppApp.swift
//  cmbSDKToolkitSampleApp
//
//
// This demo app has been designed to show how simple it is to write a single application
// using cmbSDK and cmbSDKToolkit frameworks that will connect to Cognex Bluetooth devices.
//
// The app uses SwiftUI that has the ContentView struct as the starting point of the view hierarchy.
// It either presents the Bluetooth pairing screens if we don’t have a paired Cognex reader yet
// or presents the scanner view to demonstrate displaying read result from the connected Cognex reader.
// From the scanner view the user can navigate to a setting view to enable/disable symbologies the reader can recognize.
//
// The Bluetooth pairing view and the symbolog setting view are loaded from cmbSDKToolkit framework
// demonstrating how these screens can be intergrated in a custom application.
//
// Copyright © 2023-present. Cognex Corporation. All rights reserved.
//

import SwiftUI

@main
struct cmbSDKToolkitSampleApp: App {
    
    let appController = AppController()
    
    var body: some Scene {
        WindowGroup {
            ContentView()
                .environmentObject(appController.appState)
                .environmentObject(appController.readerManager)
        }
    }
}
