class cmbCameraMode {
  // Use camera with no aimer. Preview is on, illumination is available.
  static const int NoAimer = 0;
  // Use camera with a basic aimer (e.g., StingRay). Preview is off, illumination is not available.
  static const int PassiveAimer = 1;
  // Use mobile device front camera. Preview is on, illumination is not available.
  static const int FrontCamera = 2;
}

class cmbPrevewiOption {
  // Use defaults (no overrides).
  static const int Defaults = 0;
  // Disable zoom feature (removes zoom button from preview).
  static const int NoZoomBtn = 1;
  // Disable illumination (removes illumination button from preview).
  static const int NoIllumBtn = 2;
  // Enables the simulated hardware trigger (the volume down button).
  static const int HwTrigger = 4;
  // When scanning starts, the preview is displayed but decoding is paused until a trigger (either the on screen button or the volume down button, if enabled) is pressed.
  static const int Paused = 8;
  // Force the preview to be displayed, even if off by default (e.g., when using PassiveAimer).
  static const int AlwaysShow = 16;
  // Use higher resolution if the device supports it. Default is 1280x720, with this param 1920x1080 will be used.
  static const int HighResolution = 32;
  // Use higher framerate if the device supports it. Default is 30 FPS, with this param 60 FPS will be used.
  static const int HighFramerate = 64;
  // Show close button in partial view.
  static const int ShowCloseButton = 128;
  // Keep the preview in paused state after read or timeout.
  static const int KeepPreviewInPausedState = 256;
  // Use 2K resolution if the device supports it. Default is 1280x720, with this param 2560x1440 will be used
  // Android platfom specific
  static const int QHDResolution = 512;
}

class cmbDeviceType {
  // Use a MX-1xxx device for scanning
  static const int MXReader = 0;
  // Use the mobile's built in camera for scanning
  static const int Camera = 2;
  // Use bluetooth device for scanning
  static const int Bluetooth = 3;
}

class cmbErrorCode {
  static const String ScannerNotInitialized = '-1';
  static const String ConnectionNotSuccessful = '-2';
  static const String ConnectionCameraPermission = '-3';
  static const String SymbologyNotFound = '-4';
  static const String SymbologyStateNotChanged = '-5';
  static const String SymbologyStateNotAvailable = '-6';
  static const String PluginDetachedFromActivity = '-7';
  static const String LightStateNotChanged = '-8';
  static const String LightStateNotAvailable = '-9';
  static const String CommandNotExecuted = '-10';
  static const String ConfigNotReseted = '-11';
  static const String BatteryLevelNotAvailable = '-12';
  static const String UnsupportedOperation = '-13';
  static const String CameraFlagNotSupported = '-14';
  static const String CameraFlagBadParam = '-15';
  static const String CameraFlagNotChanged = '-16';
  static const String ParserNotFound = '-17';
  static const String EncodingNotFound = '-18';
  static const String ScannerNotConnected = '-19';
  static const String InvalidImageSource = '-20';
  static const String FailedToReadImage = '-21';
  static const String BluetoothPermissions = '-22';
  static const String PairedBtDeviceNotFound = '-23';
}

enum cmbOverlayMode { OMCmb, OMLegacy }

enum cmbAvailability { Unknown, Available, Unavailable }

enum cmbConnectionState { Disconnected, Connecting, Connected, Disconnecting }

enum cmbResultParser { None, Auto, Aamva, Gs1, Hibc, Isbt128, Iuid, Scm }

enum cmbReadStringEncoding {
  Auto,
  Utf8,
  Utf16,
  Utf32,
  Iso88591,
  Iso88592,
  ShiftJis,
  UsAscii,
  UsAsciiShowNonPrintable
}

enum cmbSymbology {
  Unknown,
  DataMatrix,
  QR,
  C128,
  UpcEan,
  C11,
  C39,
  C93,
  I2o5,
  CodaBar,
  EanUcc,
  PharmaCode,
  Maxicode,
  Pdf417,
  Micropdf417,
  Databar,
  Planet,
  Postnet,
  FourStateJap,
  FourStateAus,
  FourStateUpu,
  FourStateImb,
  Vericode,
  Rpc,
  Msi,
  Azteccode,
  Dotcode,
  C25,
  C39ConvertToC32,
  Ocr,
  FourStateRm,
  Telepen
}
